<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Model\Sitemap;

/**
 * Class ChangeFreq
 * @package GenericSitemap\Model\Sitemap
 */
class ChangeFreq
{
    /**
     * @var string
     */
    const ALWAYS = 'always';

    /**
     * @var string
     */
    const HOURLY = 'hourly';

    /**
     * @var string
     */
    const DAILY = 'daily';

    /**
     * @var string
     */
    const WEEKLY = 'weekly';

    /**
     * @var string
     */
    const MONTHLY = 'monthly';

    /**
     * @var string
     */
    const YEARLY = 'yearly';

    /**
     * @var string
     */
    const NEVER = 'never';

    /**
     * @param $changeFreq string
     * @return bool
     */
    public static function isValid($changeFreq)
    {
        return in_array($changeFreq, [
            self::ALWAYS,
            self::HOURLY,
            self::DAILY,
            self::WEEKLY,
            self::MONTHLY,
            self::YEARLY,
            self::NEVER,
        ]);
    }
}
