<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Model\Sitemap;

use DateTime;

/**
 * Class Lastmod
 * @package GenericSitemap\Model\Sitemap
 */
class Lastmod
{
    /**
     * @var string
     */
    const FORMAT = 'Y-m-d';

    /**
     * @param string $lastmod
     * @return bool
     */
    public static function isValid($lastmod)
    {
        $datetime = DateTime::createFromFormat(self::FORMAT, $lastmod);

        return ($datetime !== false && $datetime->format(self::FORMAT) === $lastmod);
    }
}
