<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Model\Sitemap;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Url
 * @package GenericSitemap\Model\Sitemap
 */
class Url
{
    /**
     * @var string
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("loc")
     * @Serializer\XmlElement(cdata=false)
     */
    private $loc;

    /**
     * @var null|string
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("lastmod")
     * @Serializer\XmlElement(cdata=false)
     */
    private $lastmod;

    /**
     * @var null|string
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("changefreq")
     * @Serializer\XmlElement(cdata=false)
     */
    private $changefreq;

    /**
     * @var null|float
     *
     * @Serializer\Type("float")
     * @Serializer\SerializedName("priority")
     * @Serializer\XmlElement(cdata=false)
     */
    private $priority;

    /**
     * Url constructor.
     * @param string $loc
     */
    public function __construct($loc)
    {
        $this->loc = $loc;
    }

    /**
     * @return string
     */
    public function getLoc()
    {
        return $this->loc;
    }

    /**
     * @param string $loc
     * @return Url
     */
    public function setLoc($loc)
    {
        $this->loc = $loc;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getLastmod()
    {
        return $this->lastmod;
    }

    /**
     * @param null|string $lastmod
     * @return Url
     */
    public function setLastmod($lastmod)
    {
        $this->lastmod = $lastmod;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getChangefreq()
    {
        return $this->changefreq;
    }

    /**
     * @param null|string $changefreq
     * @return Url
     */
    public function setChangefreq($changefreq)
    {
        $this->changefreq = $changefreq;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * @param float|null $priority
     * @return Url
     */
    public function setPriority($priority)
    {
        $this->priority = $priority;
        return $this;
    }
}
