<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Model;

use GenericSitemap\Model\Sitemap\Urlset;

/**
 * Class AliasSitemap
 * @package GenericSitemap\Model
 */
class SitemapInput
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var array|Urlset[]
     */
    private $urlsetList;

    /**
     * SitemapAlias constructor.
     * @param string $name
     */
    public function __construct($name)
    {
        $this->name = $name;
        $this->urlsetList = [];
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return SitemapInput
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @param Urlset $urlset
     * @return SitemapInput
     */
    public function addUrlset($urlset)
    {
        $this->urlsetList[] = $urlset;
        return $this;
    }

    /**
     * @return array|Urlset[]
     */
    public function getUrlsetList()
    {
        return $this->urlsetList;
    }

    /**
     * @param array|Urlset[] $urlsetList
     * @return SitemapInput
     */
    public function setUrlsetList($urlsetList)
    {
        $this->urlsetList = $urlsetList;
        return $this;
    }
}
