<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Utils;

/**
 * Class Formatter
 * @package GenericSitemap\Utils
 */
final class Escaper
{
    /**
     * @param string $value
     * @param bool $encodeHtsc
     * @return null|string
     */
    public function escape($value, $encodeHtsc = false)
    {
        $value = $this->escapeNonPrintableAsciiCharacters($value);

        if ($encodeHtsc && $value) {
            $value = htmlspecialchars($value, ENT_QUOTES | ENT_XML1, 'UTF-8', true);
        }

        return $value;
    }

    /**
     * @see https://en.wikipedia.org/wiki/ASCII#Printable_characters More information.
     * @param string $value
     * @return null|string
     */
    private function escapeNonPrintableAsciiCharacters($value)
    {
        return preg_replace_callback('/[^\x20-\x7f]/', function ($match) {
            return rawurlencode($match[0]);
        }, $value);
    }
}
