<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Utils;

/**
 * Class SitemapUrlCreator
 * @package GenericSitemap\Utils
 */
class SitemapUrlFormatter implements FormatterInterface
{
    /**
     * @var string
     */
    const DEFAULT_URL_FORMAT = '%1$s/%2$s.xml';

    /**
     * @var string
     */
    protected $baseUrl;

    /**
     * @var string
     */
    protected $urlFormat;

    /**
     * SitemapUrlCreator constructor.
     * @param string $baseUrl
     */
    public function __construct($baseUrl)
    {
        $this->baseUrl = $baseUrl;
        $this->urlFormat = self::DEFAULT_URL_FORMAT;
    }

    /**
     * @param array $data
     * @return string
     */
    public function format($data)
    {
        $data = array_merge([
            $this->baseUrl,
        ], $data);

        return vsprintf($this->urlFormat, $data);
    }

    /**
     * @return string
     */
    public function getBaseUrl()
    {
        return $this->baseUrl;
    }

    /**
     * @return string
     */
    public function getUrlFormat()
    {
        return $this->urlFormat;
    }

    /**
     * @param string $urlFormat
     * @return SitemapUrlFormatter
     */
    public function setUrlFormat($urlFormat)
    {
        $this->urlFormat = $urlFormat;
        return $this;
    }
}
