<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Tests\GenericSitemap\Builder;

use GenericSitemap\Builder\SitemapGeneratorBuilder;
use GenericSitemap\Generator\SitemapGenerator;
use GenericSitemap\Generator\Type\SitemapGeneratorType;
use GenericSitemap\Generator\Type\SitemapIndexGeneratorType;
use GenericSitemap\Serializer\JMSSitemapSerializer;
use GenericSitemap\Utils\Escaper;
use GenericSitemap\Utils\SitemapGeneratorInputNormalizer;
use GenericSitemap\Utils\SitemapUrlFormatter;
use PHPUnit\Framework\TestCase;

class SitemapGeneratorBuilderTest extends TestCase
{
    /**
     * @var SitemapGeneratorBuilder
     */
    private $builder;

    protected function setUp()
    {
        $this->builder = SitemapGeneratorBuilder::create();
        $this->builder->build();
    }

    public function test_build_sitemap_generator_return_value()
    {
        $builder = SitemapGeneratorBuilder::create();

        $this->assertInstanceOf(
            SitemapGenerator::class,
            $builder->build()
        );
    }

    public function test_build_sitemap_generator_with_default_escaper()
    {
        $this->assertInstanceOf(
            Escaper::class,
            $this->builder->getEscaper()
        );
    }

    public function test_build_sitemap_generator_with_default_serializer()
    {
        $this->assertInstanceOf(
            JMSSitemapSerializer::class,
            $this->builder->getSitemapSerializer()
        );
    }

    public function test_build_sitemap_generator_with_default_url_formatter()
    {
        $this->assertInstanceOf(
            SitemapUrlFormatter::class,
            $this->builder->getUrlFormatter()
        );
    }

    public function test_build_sitemap_generator_with_default_generator_type_list()
    {
        $generatorTypeList = $this->builder->getSitemapGeneratorTypeList();

        $this->assertInternalType(
            'array',
            $generatorTypeList
        );

        $this->assertCount(
            2,
            $generatorTypeList
        );

        $this->assertInstanceOf(
            SitemapGeneratorType::class,
            $generatorTypeList[0]
        );

        $this->assertInstanceOf(
            SitemapIndexGeneratorType::class,
            $generatorTypeList[1]
        );
    }

    public function test_build_sitemap_generator_with_default_max_urlset_size()
    {
        $this->assertSame(
            5000, // SitemapGeneratorBuilder::DEFAULT_MAX_URLSET_SIZE
            $this->builder->getMaxUrlsetSize()
        );
    }

    public function test_build_sitemap_generator_with_default_sitemap_generator_input_normalizer()
    {
        $this->assertInstanceOf(
            SitemapGeneratorInputNormalizer::class,
            $this->builder->getSitemapGeneratorInputNormalizer()
        );
    }


}
