<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Tests\GenericSitemap\Generator;

use GenericSitemap\Builder\SitemapGeneratorBuilder;
use GenericSitemap\Generator\SitemapGenerator;
use GenericSitemap\Model\Sitemap\ChangeFreq;
use GenericSitemap\Model\Sitemap\Urlset;
use GenericSitemap\Model\SitemapGeneratorInput;
use GenericSitemap\Model\SitemapGeneratorOutput;
use PHPUnit\Framework\TestCase;

class SitemapGeneratorTest extends TestCase
{
    /**
     * @var SitemapGenerator
     */
    private $sitemapGenerator;

    protected function setUp()
    {
        $this->sitemapGenerator = SitemapGeneratorBuilder::create()
            ->build();
    }

    public function test_generate()
    {
        $sitemapGeneratorInput = ((new SitemapGeneratorInput())
            ->addData(
                'blog-post',
                (new Urlset())
                    // blog-post-0
                    ->addData('http://www.any-page.com/blog/post/0')
                    ->addData('http://www.any-page.com/blog/post/1')
                    ->addData('http://www.any-page.com/blog/post/2')
                    ->addData('http://www.any-page.com/blog/post/3')
                    ->addData('http://www.any-page.com/blog/post/4')
                    // blog-post-1
                    ->addData('http://www.any-page.com/blog/post/5')
                    ->addData('http://www.any-page.com/blog/post/6')
                    ->addData('http://www.any-page.com/blog/post/7')
            )
            ->addData(
                'blog-list',
                (new Urlset())
                    // blog-list-0
                    ->addData(
                        'http://www.any-page.com/blog/post',
                        date('Y-m-d'),
                        ChangeFreq::MONTHLY,
                        1.0
                    )
            )
        );

        $sitemapGeneratorOutput = $this->sitemapGenerator->generate($sitemapGeneratorInput);

        $this->assertInstanceOf(
            SitemapGeneratorOutput::class,
            $sitemapGeneratorOutput
        );
    }
}
