<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Tests\GenericSitemap\Model\Sitemap;

use GenericSitemap\Model\Sitemap\ChangeFreq;
use PHPUnit\Framework\TestCase;

class ChangeFreqTest extends TestCase
{
    public function test_is_valid_with_valid_change_freqs()
    {
        $this->assertTrue(
            ChangeFreq::isValid(ChangeFreq::ALWAYS)
        );

        $this->assertTrue(
            ChangeFreq::isValid(ChangeFreq::HOURLY)
        );

        $this->assertTrue(
            ChangeFreq::isValid(ChangeFreq::DAILY)
        );

        $this->assertTrue(
            ChangeFreq::isValid(ChangeFreq::WEEKLY)
        );

        $this->assertTrue(
            ChangeFreq::isValid(ChangeFreq::MONTHLY)
        );

        $this->assertTrue(
            ChangeFreq::isValid(ChangeFreq::YEARLY)
        );

        $this->assertTrue(
            ChangeFreq::isValid(ChangeFreq::NEVER)
        );
    }

    public function test_is_valid_with_invalid_change_freqs()
    {
        $this->assertNotTrue(
            ChangeFreq::isValid('change')
        );

        $this->assertNotTrue(
            ChangeFreq::isValid('')
        );
    }
}
