<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Tests\GenericSitemap\Utils;

use GenericSitemap\Utils\Escaper;
use PHPUnit\Framework\TestCase;

/**
 * Class FormatterTest
 * @package Tests\GenericSitemap\Utils
 */
class EscaperTest extends TestCase
{
    /**
     * @var Escaper
     */
    private $escaper;

    protected function setUp()
    {
        $this->escaper = new Escaper();
    }


    public function test_escape_value_with_umlauts()
    {
        $this->assertSame(
            'Ganzk%C3%B6rperk%C3%A4seso%C3%9Fentauchfr%C3%BChst%C3%BCck',
            $this->escaper->escape('Ganzkörperkäsesoßentauchfrühstück', true)
        );
    }

    public function test_escape_value_without_umlauts()
    {
        $this->assertSame(
            'Ein ganz normaler Satz.',
            $this->escaper->escape('Ein ganz normaler Satz.', true)
        );
    }

    public function test_escape_value_with_htmlspecialchars()
    {
        $this->assertSame(
            'Dies hier ist ein &lt;b&gt;Test&lt;/b&gt;.',
            $this->escaper->escape('Dies hier ist ein <b>Test</b>.', true)
        );
    }

    public function test_escape_value_with_single_quotes()
    {
        $this->assertSame(
            'Mit einfachem Anf%C3%BChrungszeichen sieht das so aus: &apos;',
            $this->escaper->escape('Mit einfachem Anführungszeichen sieht das so aus: \'', true)
        );
    }

    public function test_escape_value_with_double_quotes()
    {
        $this->assertSame(
            'Und mit doppeltem Anf%C3%BChrungszeichen sieht das dann so aus: &quot;',
            $this->escaper->escape('Und mit doppeltem Anführungszeichen sieht das dann so aus: "', true)
        );
    }

    /**
     * Example taken from https://www.sitemaps.org/protocol.html#escaping
     */
    public function test_escape_value_with_url()
    {
        $this->assertSame(
            'http://www.example.com/%C3%BCmlat.php&amp;q=name',
            $this->escaper->escape('http://www.example.com/ümlat.php&q=name', true)
        );
    }
}
