<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Tests\GenericSitemap\Utils;

use GenericSitemap\Utils\SitemapUrlFormatter;
use PHPUnit\Framework\TestCase;

class SitemapUrlFormatterTest extends TestCase
{
    /**
     * @var SitemapUrlFormatter
     */
    private $formatter;

    protected function setUp()
    {
        $baseUrl = rtrim('http://www.example.com/', '/');

        $this->formatter = new SitemapUrlFormatter($baseUrl);
    }

    public function test_format()
    {
        $name = 'sitemap-0';

        $this->assertSame(
            'http://www.example.com/sitemap-0.xml',
            $this->formatter->format([$name])
        );
    }

    public function test_path_format()
    {
        $path = '/test/asdf';
        $name = 'sitemap-0';

        $this->formatter->setUrlFormat('%1$s%2$s/%3$s.xml');

        $this->assertSame(
            'http://www.example.com/test/asdf/sitemap-0.xml',
            $this->formatter->format([$path, $name])
        );
    }
}
