<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

use Doctrine\Common\Annotations\AnnotationRegistry;
use GenericSitemap\Builder\SitemapGeneratorBuilder;
use GenericSitemap\Generator\SitemapGenerator;
use GenericSitemap\Model\Sitemap\ChangeFreq;
use GenericSitemap\Model\Sitemap\Urlset;
use GenericSitemap\Model\SitemapGeneratorInput;

require_once('vendor/autoload.php');

AnnotationRegistry::registerLoader('class_exists');

/** @var SitemapGenerator $gen */
$gen = SitemapGeneratorBuilder::create()
    ->setUrlFormatterForUrl('http://www.any-page.de/')
    ->setMaxUrlsetSize(2)
    ->build();

$input = ((new SitemapGeneratorInput())
    ->addData(
        'sitemap',
        (new Urlset())
            ->addData('http://www.any-page.com/dump/link')
            ->addData(
                'http://www.any-page.com/asdf/äöü/index.php?msg=<>#',
                date('Y-m-d'),
                ChangeFreq::MONTHLY,
                1.0
            )
            ->addData(
                'http://www.any-page.de/comp/7748/t?command=select&target=db_sql,cache&where=[index=0]().exe#term',
                date('Y-m-d', (time() - 60 * 60 * 24 * 7)),
                ChangeFreq::DAILY
            )
    )
);

$output = $gen->generate($input);

foreach ($output->getSitemapOutputList() as $sitemapOutput) {
    print 'Name: ';
    print $sitemapOutput->getName();
    print PHP_EOL;
    print 'Type: ';
    print $sitemapOutput->getType();
    print PHP_EOL;
    print 'Content: ';
    print PHP_EOL;
    print $sitemapOutput->getContent();
    print PHP_EOL;
}
