<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Generator;

use GenericSitemap\Generator\Type\SitemapGeneratorTypeInterface;
use GenericSitemap\Model\SitemapGeneratorInput;
use GenericSitemap\Model\SitemapGeneratorOutput;
use GenericSitemap\Utils\SitemapGeneratorInputNormalizerInterface;

/**
 * Class SitemapGenerator
 * @package GenericSitemap\Generator
 */
class SitemapGenerator
{
    /**
     * @var array|SitemapGeneratorTypeInterface[]
     */
    private $sitemapGenerytorTypeList;

    /**
     * @var SitemapGeneratorInputNormalizerInterface
     */
    private $sitemapGeneratorInputNormalizer;

    /**
     * SitemapGenerator constructor.
     * @param array|SitemapGeneratorTypeInterface[] $sitemapGenerytorTypeList
     * @param SitemapGeneratorInputNormalizerInterface $sitemapGeneratorInputNormalizer
     */
    public function __construct($sitemapGenerytorTypeList, $sitemapGeneratorInputNormalizer)
    {
        $this->sitemapGenerytorTypeList = $sitemapGenerytorTypeList;
        $this->sitemapGeneratorInputNormalizer = $sitemapGeneratorInputNormalizer;
    }

    /**
     * @param SitemapGeneratorInput $sitemapGeneratorInput
     * @return SitemapGeneratorOutput
     */
    public function generate($sitemapGeneratorInput)
    {
        $sitemapGeneratorInput = $this->sitemapGeneratorInputNormalizer->normalize($sitemapGeneratorInput);
        $sitemapGeneratorOutput = new SitemapGeneratorOutput();

        foreach ($this->sitemapGenerytorTypeList as $sitemapGeneratorType) {
            $sitemapGeneratorType->generate($sitemapGeneratorInput, $sitemapGeneratorOutput);
        }

        return $sitemapGeneratorOutput;
    }
}
