<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Generator\Type;

use GenericSitemap\Model\SitemapGeneratorInput;
use GenericSitemap\Model\SitemapGeneratorOutput;
use GenericSitemap\Model\SitemapIndex\SitemapIndex;
use GenericSitemap\Serializer\SitemapSerializerInterface;
use GenericSitemap\Utils\Escaper;
use GenericSitemap\Utils\FormatterInterface;

/**
 * Class SitemapIndexGeneratorType
 * @package GenericSitemap\Generator\Type
 */
final class SitemapIndexGeneratorType extends AbstractGeneratorType
{
    /**
     * @var string
     */
    const TYPE = 'SitemapIndex';

    /**
     * @var string
     */
    const NAME = 'sitemap';

    /**
     * @var FormatterInterface
     */
    private $urlFormatter;

    /**
     * @var Escaper
     */
    private $escaper;

    /**
     * SitemapIndexGeneratorType constructor.
     * @param SitemapSerializerInterface $serializer
     * @param FormatterInterface $urlFormatter
     * @param Escaper $escaper
     */
    public function __construct($serializer, $urlFormatter, $escaper)
    {
        parent::__construct($serializer);

        $this->urlFormatter = $urlFormatter;
        $this->escaper = $escaper;
    }

    /**
     * @param SitemapGeneratorInput $sitemapGeneratorInput
     * @param SitemapGeneratorOutput $sitemapGeneratorOutput
     * @return void
     */
    public function generate($sitemapGeneratorInput, $sitemapGeneratorOutput)
    {
        $sitemapIndex = new SitemapIndex();

        foreach ($sitemapGeneratorInput->getSitemapInputList() as $sitemapInput) {
            foreach ($sitemapInput->getUrlsetList() as $index => $urlset) {
                $name = $sitemapInput->getName() . '-' . $index;

                $loc = $this->urlFormatter->format([
                    $name,
                    $index,
                ]);
                $loc = $this->escaper->escape($loc, false);
                $lastmod = date('Y-m-d');

                $sitemapIndex->addData($loc, $lastmod);
            }
        }

        $content = $this->serializer->serialize($sitemapIndex);

        $sitemapGeneratorOutput->addData(self::TYPE, self::NAME, $content);
    }
}
