<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Model;

/**
 * Class SitemapResponseModel
 * @package GenericSitemap\Model
 */
class SitemapGeneratorOutput
{
    /**
     * @var array|SitemapOutput[]
     */
    private $sitemapOutputList;

    /**
     * SitemapGeneratorOutput constructor.
     */
    public function __construct()
    {
        $this->sitemapOutputList = [];
    }

    /**
     * @param string $type
     * @param string $name
     * @param string $content
     * @return SitemapGeneratorOutput
     */
    public function addData($type, $name, $content)
    {
        $sitemapOutput = new SitemapOutput($type, $name);
        $sitemapOutput->setContent($content);
        return $this->addSitemapOutput($sitemapOutput);
    }

    /**
     * @param SitemapOutput $sitemapOutput
     * @return SitemapGeneratorOutput
     */
    public function addSitemapOutput($sitemapOutput)
    {
        $this->sitemapOutputList[] = $sitemapOutput;
        return $this;
    }

    /**
     * @return array|SitemapOutput[]
     */
    public function getSitemapOutputList()
    {
        return $this->sitemapOutputList;
    }

    /**
     * @param array|SitemapOutput[] $sitemapOutputList
     * @return SitemapGeneratorOutput
     */
    public function setSitemapOutputList($sitemapOutputList)
    {
        $this->sitemapOutputList = $sitemapOutputList;
        return $this;
    }
}
