<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Model\SitemapIndex;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Sitemap
 * @package GenericSitemap\Model\SitemapIndex
 */
class Sitemap
{
    /**
     * @var string
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("loc")
     * @Serializer\XmlElement(cdata=false)
     */
    private $loc;

    /**
     * @var null|string
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("lastmod")
     * @Serializer\XmlElement(cdata=false)
     */
    private $lastmod;

    /**
     * Sitemap constructor.
     * @param string $loc
     */
    public function __construct($loc)
    {
        $this->loc = $loc;
    }

    /**
     * @return string
     */
    public function getLoc()
    {
        return $this->loc;
    }

    /**
     * @param string $loc
     * @return Sitemap
     */
    public function setLoc($loc)
    {
        $this->loc = $loc;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getLastmod()
    {
        return $this->lastmod;
    }

    /**
     * @param null|string $lastmod
     * @return Sitemap
     */
    public function setLastmod($lastmod)
    {
        $this->lastmod = $lastmod;
        return $this;
    }
}
