<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Serializer;

use JMS\Serializer\SerializerBuilder;
use JMS\Serializer\SerializerInterface;

/**
 * Class JMSSerializer
 * @package GenericSitemap\Serializer
 */
class JMSSitemapSerializer implements SitemapSerializerInterface
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var string
     */
    private $serializerFormat;

    /**
     * JMSSitemapSerializer constructor.
     */
    public function __construct()
    {
        $this->serializer = SerializerBuilder::create()
            ->addDefaultHandlers()
            ->build();
        $this->serializerFormat = 'xml';
    }

    /**
     * @param mixed $data
     * @return string
     */
    public function serialize($data)
    {
        return $this->serializer->serialize($data, $this->serializerFormat);
    }
}
