<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Tests\GenericSitemap\Model\Sitemap;

use GenericSitemap\Model\Sitemap\Priority;
use PHPUnit\Framework\TestCase;

class PriorityTest extends TestCase
{
    public function test_get_priority_with_priority_in_range()
    {
        $this->assertSame(
            0.0,
            Priority::getPriority(0.0)
        );

        $this->assertSame(
            0.3,
            Priority::getPriority(0.3)
        );

        $this->assertSame(
            0.7,
            Priority::getPriority(0.7)
        );

        $this->assertSame(
            1.0,
            Priority::getPriority(1.0)
        );
    }

    public function test_get_priority_with_priority_not_in_range()
    {
        $this->assertSame(
            1.0,
            Priority::getPriority(2.0)
        );

        $this->assertSame(
            0.0,
            Priority::getPriority(-1.0)
        );
    }
}
