<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Tests\GenericSitemap\Utils;

use GenericSitemap\Model\Sitemap\ChangeFreq;
use GenericSitemap\Model\Sitemap\Urlset;
use GenericSitemap\Model\SitemapGeneratorInput;
use GenericSitemap\Model\SitemapInput;
use GenericSitemap\Utils\Escaper;
use GenericSitemap\Utils\SitemapGeneratorInputNormalizer;
use PHPUnit\Framework\TestCase;

class SitemapGeneratorInputNormalizerTest extends TestCase
{
    /**
     * @var SitemapGeneratorInputNormalizer
     */
    private $normalizer;

    protected function setUp()
    {
        $escaper = new Escaper();

        $this->normalizer = new SitemapGeneratorInputNormalizer(5, $escaper);
    }

    public function test_normalize()
    {
        $sitemapGeneratorInput = ((new SitemapGeneratorInput())
            ->addData(
                'blog-post',
                (new Urlset())
                    // blog-post-0
                    ->addData('http://www.any-page.com/blog/post/0')
                    ->addData('http://www.any-page.com/blog/post/1')
                    ->addData('http://www.any-page.com/blog/post/2')
                    ->addData('http://www.any-page.com/blog/post/3')
                    ->addData('http://www.any-page.com/blog/post/4')
                    // blog-post-1
                    ->addData('http://www.any-page.com/blog/post/5')
                    ->addData('http://www.any-page.com/blog/post/6')
                    ->addData('http://www.any-page.com/blog/post/7')
            )
            ->addData(
                'blog-list',
                (new Urlset())
                    // blog-list-0
                    ->addData(
                        'http://www.any-page.com/blog/post',
                        date('Y-m-d'),
                        ChangeFreq::MONTHLY,
                        1.0
                    )
            )
        );

        // normalize
        $sitemapGeneratorInput = $this->normalizer->normalize($sitemapGeneratorInput);

        $this->assertInstanceOf(
            SitemapGeneratorInput::class,
            $sitemapGeneratorInput
        );

        $sitemapInputList = $sitemapGeneratorInput->getSitemapInputList();

        $this->assertInternalType(
            'array',
            $sitemapInputList
        );

        $this->assertCount(
            2,
            $sitemapInputList
        );

        // 0
        $this->assertInstanceOf(
            SitemapInput::class,
            $sitemapInputList[0]
        );

        $this->assertInternalType(
            'array',
            $sitemapInputList[0]->getUrlsetList()
        );

        $this->assertCount(
            2,
            $sitemapInputList[0]->getUrlsetList()
        );

        // 1
        $this->assertInstanceOf(
            SitemapInput::class,
            $sitemapInputList[1]
        );

        $this->assertInternalType(
            'array',
            $sitemapInputList[1]->getUrlsetList()
        );

        $this->assertCount(
            1,
            $sitemapInputList[1]->getUrlsetList()
        );
    }
}
