<?php

/**
 * Id-Generator for entities
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\ORMHelperBundle\Helper;

use \Doctrine\ORM\Id\AbstractIdGenerator;

/**
 * Id-Generator for entities (sha256, 64 chars)
 */
class Id64Generator extends AbstractIdGenerator
{

    public function generate(\Doctrine\ORM\EntityManager $em, $entity)
    {
        return hash('sha256', mt_rand() . '#' . microtime());
    }

}