<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Model\Wirecard\Authorization\Request\Version1;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 * @package App\Services\LightWeight\Request\Version1
 * @Serializer\XmlRoot("lightWeightRequest")
 */
class Request
{
    /**
     * @Assert\Length(
     *      max = 49,
     *      maxMessage = "firstName cannot be longer than {{ limit }} characters"
     * )
     * @Serializer\Type("string")
     * @Serializer\SerializedName("firstName")
     * @var string|null
     */
    private $firstName;

    /**
     * @Assert\Length(
     *      max = 49,
     *      maxMessage = "lastName cannot be longer than {{ limit }} characters"
     * )
     * @Serializer\Type("string")
     * @Serializer\SerializedName("lastName")
     * @var string|null
     */
    private $lastName;

    /**
     * @Assert\NotBlank()
     * @Serializer\SerializedName("tokenId")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $tokenId;

    /**
     * @Assert\NotBlank()
     * @Serializer\SerializedName("amount")
     * @Serializer\Type("float")
     * @var float|null
     */
    private $amount;

    /**
     * @Assert\NotBlank()
     * @Serializer\SerializedName("currency")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $currency;

    /**
     * @Serializer\SerializedName("clientId")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $clientId;

    /**
     * @return string|null
     */
    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    /**
     * @param string|null $firstName
     * @return Request
     */
    public function setFirstName(?string $firstName): Request
    {
        $this->firstName = $firstName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    /**
     * @param string|null $lastName
     * @return Request
     */
    public function setLastName(?string $lastName): Request
    {
        $this->lastName = $lastName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTokenId(): ?string
    {
        return $this->tokenId;
    }

    /**
     * @param string|null $tokenId
     * @return Request
     */
    public function setTokenId(?string $tokenId): Request
    {
        $this->tokenId = $tokenId;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getAmount(): ?float
    {
        return $this->amount;
    }

    /**
     * @param float|null $amount
     * @return Request
     */
    public function setAmount(?float $amount): Request
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCurrency(): ?string
    {
        return $this->currency;
    }

    /**
     * @param string|null $currency
     * @return Request
     */
    public function setCurrency(?string $currency): Request
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getClientId(): ?string
    {
        return $this->clientId;
    }

    /**
     * @param string|null $clientId
     * @return Request
     */
    public function setClientId(?string $clientId): Request
    {
        $this->clientId = $clientId;
        return $this;
    }
}
