<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Model\Wirecard\Authorization\Response\Version1;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 * @package App\Services\LightWeight\Response\Version1
 * @Serializer\XmlRoot("lightWeightResponse")
 */
class Response
{
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("format")
     * @var string
     */
    private $format;

    /**
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("code")
     * @var integer
     */
    private $code;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("status")
     * @var string
     */
    private $status;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("message")
     * @var string
     */
    private $message;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("trackId")
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\Type("double")
     * @Serializer\SerializedName("scriptTimeSec")
     * @var float
     */
    private $scriptTimeSec;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("firstName")
     * @var string|null
     */
    private $firstName;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("lastName")
     * @var string|null
     */
    private $lastName;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("tokenId")
     * @var string
     */
    private $tokenId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("maskedAccountNumber")
     * @var string
     */
    private $maskedAccountNumber;

    /**
     * @Serializer\Exclude()
     * @var StatusCodes
     */
    private $codeToStatus;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("transactionId")
     * @var string|null
     */
    private $transactionId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("requestId")
     * @var string|null
     */
    private $requestId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("currency")
     * @var string|null
     */
    private $currency;

    /**
     * @Serializer\Type("float")
     * @Serializer\SerializedName("amount")
     * @var float|null
     */
    private $amount;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("descriptor")
     * @var string|null
     */
    private $descriptor;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("authorizationCode")
     * @var string|null
     */
    private $authorizationCode;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->codeToStatus = new StatusCodes();
    }

    /**
     * @return string
     */
    public function getFormat(): string
    {
        return $this->format;
    }

    /**
     * @param string $format
     */
    public function setFormat(string $format): void
    {
        $this->format = $format;
    }

    /**
     * @return int
     */
    public function getCode(): int
    {
        return $this->code;
    }

    /**
     * @param int $code
     */
    public function setCode(int $code): void
    {
        $this->message = $this->codeToStatus->codeToStatus($code);
        $this->code = $code;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }

    /**
     * @param string $status
     */
    public function setStatus(string $status): void
    {
        $this->status = $status;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->message;
    }

    /**
     * @param string $message
     */
    public function setMessage(string $message): void
    {
        $this->message = $message;
    }

    /**
     * @return string
     */
    public function getTrackId(): string
    {
        return $this->trackId;
    }

    /**
     * @param string $trackId
     */
    public function setTrackId(string $trackId): void
    {
        $this->trackId = $trackId;
    }

    /**
     * @return float
     */
    public function getScriptTimeSec(): float
    {
        return $this->scriptTimeSec;
    }

    /**
     * @param float $scriptTimeSec
     */
    public function setScriptTimeSec(float $scriptTimeSec): void
    {
        $this->scriptTimeSec = $scriptTimeSec;
    }

    /**
     * @return string|null
     */
    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    /**
     * @param string|null $firstName
     */
    public function setFirstName(?string $firstName): void
    {
        $this->firstName = $firstName;
    }

    /**
     * @return string|null
     */
    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    /**
     * @param string|null $lastName
     */
    public function setLastName(?string $lastName): void
    {
        $this->lastName = $lastName;
    }

    /**
     * @return string
     */
    public function getTokenId(): string
    {
        return $this->tokenId;
    }

    /**
     * @param string $tokenId
     */
    public function setTokenId(string $tokenId): void
    {
        $this->tokenId = $tokenId;
    }

    /**
     * @return string
     */
    public function getMaskedAccountNumber(): string
    {
        return $this->maskedAccountNumber;
    }

    /**
     * @param string $maskedAccountNumber
     */
    public function setMaskedAccountNumber(string $maskedAccountNumber): void
    {
        $this->maskedAccountNumber = $maskedAccountNumber;
    }

    /**
     * @return null|string
     */
    public function getResponseXmlBody(): ?string
    {
        return null;
    }

    /**
     * @return StatusCodes
     */
    public function getCodeToStatus(): StatusCodes
    {
        return $this->codeToStatus;
    }

    /**
     * @param StatusCodes $codeToStatus
     * @return Response
     */
    public function setCodeToStatus(StatusCodes $codeToStatus): Response
    {
        $this->codeToStatus = $codeToStatus;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTransactionId(): ?string
    {
        return $this->transactionId;
    }

    /**
     * @param string|null $transactionId
     * @return Response
     */
    public function setTransactionId(?string $transactionId): Response
    {
        $this->transactionId = $transactionId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getRequestId(): ?string
    {
        return $this->requestId;
    }

    /**
     * @param string|null $requestId
     * @return Response
     */
    public function setRequestId(?string $requestId): Response
    {
        $this->requestId = $requestId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCurrency(): ?string
    {
        return $this->currency;
    }

    /**
     * @param string|null $currency
     * @return Response
     */
    public function setCurrency(?string $currency): Response
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getAmount(): ?float
    {
        return $this->amount;
    }

    /**
     * @param float|null $amount
     * @return Response
     */
    public function setAmount(?float $amount): Response
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescriptor(): ?string
    {
        return $this->descriptor;
    }

    /**
     * @param string|null $descriptor
     * @return Response
     */
    public function setDescriptor(?string $descriptor): Response
    {
        $this->descriptor = $descriptor;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAuthorizationCode(): ?string
    {
        return $this->authorizationCode;
    }

    /**
     * @param string|null $authorizationCode
     * @return Response
     */
    public function setAuthorizationCode(?string $authorizationCode): Response
    {
        $this->authorizationCode = $authorizationCode;
        return $this;
    }
}
