# Payment-Service SDK Bundle

## Installation

Add the GIT repository to the composr config (for as long as the bundle hasn't been put on the internal package-server):

    composer config repositories.payment-service-sdk git ssh://git@stash.life-style.de:7999/vt/paymentservice-sdk-bundle.git
    
You can also manually add this repository to your composer.json file

    "repositories": [
            {
                "type": "git",
                "url": "ssh://git@stash.life-style.de:7999/vt/paymentservice-sdk-bundle.git"
            }
        ]

Add the following configuration to your application:
    
    lifestyle_payment_service_sdk:
        url: 'http://<url-to-payment-service-without-trailing-slash>'
        apiToken: 'YourApiTokenHere'

Now add the package via composer by running:

    composer require lifestyle/paymentservice-sdk-bundle
    
Make sure that the SDK is loaded (config/bundles.php)

    Lifestyle\PaymentServiceSdk\LifestylePaymentServiceSdkBundle::class => ['all' => true],
    

## Usage

**This SDK currently supports two wirecard API-Requests purchase Debit/CreditCard**

## Do a wirecard purchase creditCard request

1. Build your own request model by implementing the following interface

       Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request\RequestDataInterface
       Lifestyle\PaymentServiceSdk\Services\Wirecard\Common\CustomFieldInterface
       
   example RequestCreditCard:
   
       use Lifestyle\PaymentServiceSdk\Services\Wirecard\Common\CustomFieldInterface;
       use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request\RequestDataInterface;
       
       class RequestCreditCard implements RequestDataInterface
       {
       
       }
       
   example CustomField:
    
        use Lifestyle\PaymentServiceSdk\Services\Wirecard\Common\CustomFieldInterface;
        
        class CustomField implements CustomFieldInterface
        {
        
        }

2. Sending your creditCard request to the api

    first get the worker for the creditCard request
    
        Lifestyle\PaymentServiceSdk\Worker\Wirecard\PurchaseCreditCard
        
    now send your request

        $response = $this->purchaseCreditCard->chargeCreditCard($purchaseCreditCardRequest, 1);
        
    Attention: Please add a version to your request and catch unexpected exceptions
        
3. Parse your creditCard response

    The response return the following interfaces
    
        Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\ResponseDataInterface
        Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\ResponseDataCustomFieldInterface


## Do a wirecard purchase debit request

1. Build your own request model by implementing the following interface

       Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\RequestDataInterface
       Lifestyle\PaymentServiceSdk\Services\Wirecard\Common\CustomFieldInterface
       
   example RequestDebit:
   
       use Lifestyle\PaymentServiceSdk\Services\Wirecard\Common\CustomFieldInterface;
       use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\RequestDataInterface;
       
       class RequestDebit implements RequestDataInterface
       {
       
       }
       
   example CustomField:
    
        use Lifestyle\PaymentServiceSdk\Services\Wirecard\Common\CustomFieldInterface;
        
        class CustomField implements CustomFieldInterface
        {
        
        }

2. Sending your debit request to the api

    first get the worker for the creditCard request
    
        Lifestyle\PaymentServiceSdk\Worker\Wirecard\PurchaseDebit
        
    now send your request

        $response = $this->purchaseDebit->chargeDebit($purchaseDebitRequest, 1);
        
    Attention: Please add a version to your request and catch unexpected exceptions
        
3. Parse your debit response

    The response return the following interfaces
    
        Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataInterface
        Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataCustomFieldInterface
