<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Configuration;

/**
 * Class Configuration
 * @package Lifestyle\PaymentServiceSdk\Configuration
 */
class ConfigModel
{
    /**
     * @var string
     */
    private $serviceUrl;

    /**
     * @var string
     */
    private $apiToken;

    /**
     * @var integer
     */
    private $timeout = 30;

    /**
     * @var integer
     */
    private $connectionTimeout = 30;

    /**
     * Configuration constructor.
     * @param string $url
     * @param string $apiToken
     */
    public function __construct(string $url, string $apiToken)
    {
        $this->serviceUrl = $url;
        $this->apiToken = $apiToken;
    }

    /**
     * @return string
     */
    public function getServiceUrl(): string
    {
        return $this->serviceUrl;
    }

    /**
     * @return string
     */
    public function getApiToken(): string
    {
        return $this->apiToken;
    }

    /**
     * @return int
     */
    public function getTimeout(): int
    {
        return $this->timeout;
    }

    /**
     * @return int
     */
    public function getConnectionTimeout(): int
    {
        return $this->connectionTimeout;
    }
}
