<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request;

use Doctrine\Common\Collections\ArrayCollection;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\Common\CustomFieldInterface;

/**
 * Interface RequestDataInterface
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request
 */
interface RequestDataInterface
{
    /**
     * @return string|null
     */
    public function getFirstName(): ?string;

    /**
     * @return string|null
     */
    public function getLastName(): ?string;

    /**
     * @return string|null
     */
    public function getProcessNumber(): ?string;

    /**
     * @return int|null
     */
    public function getTokenId(): ?int;

    /**
     * @return float|null
     */
    public function getAmount(): ?float;

    /**
     * @return string|null
     */
    public function getCurrency(): ?string;

    /**
     * @return string|null
     */
    public function getClient(): ?string;

    /**
     * @return CustomFieldInterface[]|ArrayCollection|null
     */
    public function getCustomFields(): ?ArrayCollection;
}
