<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\Version1;

use JMS\Serializer\Annotation as Serializer;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\ResponseDataCardTokenInterface;

/**
 * Class CardToken
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\Version1
 */
class CardToken implements ResponseDataCardTokenInterface
{
    /**
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("tokenId")
     * @var integer|null
     */
    private $tokenId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("maskedAccountNumber")
     * @var string|null
     */
    private $maskedAccountNumber;

    /**
     * @return integer|null
     */
    public function getTokenId(): ?int
    {
        return $this->tokenId;
    }

    /**
     * @param integer|null $tokenId
     */
    public function setTokenId(?int $tokenId): void
    {
        $this->tokenId = $tokenId;
    }

    /**
     * @return string|null
     */
    public function getMaskedAccountNumber(): ?string
    {
        return $this->maskedAccountNumber;
    }

    /**
     * @param string|null $maskedAccountNumber
     */
    public function setMaskedAccountNumber(?string $maskedAccountNumber): void
    {
        $this->maskedAccountNumber = $maskedAccountNumber;
    }
}
