<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit;

use Lifestyle\PaymentServiceSdk\Exceptions\InvalidRequestVersionException;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Processor\ProcessorFactory;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\RequestDataInterface;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataInterface;

/**
 * Class Handler
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit
 */
class Handler
{
    /**
     * @var ProcessorFactory
     */
    private $processorFactory;

    /**
     * Handler constructor.
     * @param ProcessorFactory $processorFactory
     */
    public function __construct(ProcessorFactory $processorFactory)
    {
        $this->processorFactory = $processorFactory;
    }

    /**
     * @param RequestDataInterface $requestData
     * @param int $apiVersion
     * @return ResponseDataInterface
     * @throws InvalidRequestVersionException
     */
    public function handle(RequestDataInterface $requestData, int $apiVersion): ResponseDataInterface
    {
        return $this->processorFactory->createProcessor($apiVersion)->process($requestData);
    }
}
