<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Processor;

use Lifestyle\PaymentServiceSdk\Exceptions\InvalidRequestVersionException;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\ProcessorInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException;

/**
 * Class ProcessorFactory
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Processor
 */
class ProcessorFactory
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * ProcessorFactory constructor.
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }

    /**
     * @param int $apiVersion
     * @return ProcessorInterface
     * @throws InvalidRequestVersionException
     */
    public function createProcessor(int $apiVersion): ProcessorInterface
    {
        try {
            return $this->container->get(__NAMESPACE__ . '\\Version' . $apiVersion . '\\Processor');
        } catch (ServiceNotFoundException $exception) {
            throw new InvalidRequestVersionException($apiVersion);
        }
    }
}
