<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1;

/**
 * Class Factory
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1
 */
class Factory
{
    /**
     * @return Request
     */
    public function request(): Request
    {
        return new Request();
    }

    /**
     * @return CustomField
     */
    public function customField(): CustomField
    {
        return new CustomField();
    }

    /**
     * @return BankAccount
     */
    public function bankAccount(): BankAccount
    {
        return new BankAccount();
    }

    /**
     * @return Mandate
     */
    public function mandate(): Mandate
    {
        return new Mandate();
    }

    /**
     * @return Periodic
     */
    public function periodic(): Periodic
    {
        return new Periodic();
    }

    /**
     * @return AccountHolder
     */
    public function accountHolder(): AccountHolder
    {
        return new AccountHolder();
    }
}
