<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1;

use DateTime;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 * @package App\Services\LightWeight\Request\Version1
 * @Serializer\XmlRoot("mandate")
 */
class Mandate
{
    /**
     * @Serializer\SerializedName("mandateId")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $mandateId;

    /**
     * @Serializer\SerializedName("mandateSignedDate")
     * @Serializer\Type("DateTime<'Y-m-d'>")
     * @var DateTime|null
     */
    private $mandateSignedDate;

    /**
     * @return string|null
     */
    public function getMandateId(): ?string
    {
        return $this->mandateId;
    }

    /**
     * @param string|null $mandateId
     */
    public function setMandateId(?string $mandateId): void
    {
        $this->mandateId = $mandateId;
    }

    /**
     * @return DateTime|null
     */
    public function getMandateSignedDate(): ?DateTime
    {
        return $this->mandateSignedDate;
    }

    /**
     * @param DateTime|null $mandateSignedDate
     */
    public function setMandateSignedDate(?DateTime $mandateSignedDate): void
    {
        $this->mandateSignedDate = $mandateSignedDate;
    }
}
