<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Periodic
 * @package App\Services\Wirecard\PurchaseDebit\Request\Version1
 */
class Periodic
{
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("periodic-type")
     * @var string|null
     */
    private $periodicType = 'recurring';

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("sequence-type")
     * @var string|null
     */
    private $sequenceType = 'recurring';

    /**
     * @return string|null
     */
    public function getPeriodicType(): ?string
    {
        return $this->periodicType;
    }

    /**
     * @param string|null $periodicType
     */
    public function setPeriodicType(?string $periodicType): void
    {
        $this->periodicType = $periodicType;
    }

    /**
     * @return string|null
     */
    public function getSequenceType(): ?string
    {
        return $this->sequenceType;
    }

    /**
     * @param string|null $sequenceType
     */
    public function setSequenceType(?string $sequenceType): void
    {
        $this->sequenceType = $sequenceType;
    }
}
