<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseCreditCard\Response\Version1;

use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\Version1\Response;
use PHPUnit\Framework\TestCase;
use JMS\Serializer\SerializerBuilder;

/**
 * Class ResponseTest
 * @package App\Tests\Services\Wirecard\Purchase\Response
 */
class ResponseTest extends TestCase
{
    public function test_response_model()
    {
        $serializer = SerializerBuilder::create()->build();

        $xmlResponseModel = $serializer->deserialize($this->getXmlString(), Response::class, 'xml');

        //also test the getter
        $this->assertEquals(200, $xmlResponseModel->getCode());
        $this->assertEquals('OK', $xmlResponseModel->getStatus());
        $this->assertEquals('Token Id generated', $xmlResponseModel->getMessage());
        $this->assertEquals('4acder45g', $xmlResponseModel->getTrackId());
        $this->assertEquals(2.04, $xmlResponseModel->getScriptTimeSec());

        $this->assertEquals('Alan', $xmlResponseModel->getAccountHolder()->getFirstName());
        $this->assertEquals('Turing', $xmlResponseModel->getAccountHolder()->getLastName());
        $this->assertEquals(1111111111, $xmlResponseModel->getCardToken()->getTokenId());
        $this->assertEquals('1234*******34345', $xmlResponseModel->getCardToken()->getMaskedAccountNumber());

        $jsonResponseModel = $serializer->deserialize($this->getJsonString(), Response::class, 'json');

        //also test the getter
        $this->assertEquals(200, $jsonResponseModel->getCode());
        $this->assertEquals('OK', $jsonResponseModel->getStatus());
        $this->assertEquals('Token Id generated', $jsonResponseModel->getMessage());
        $this->assertEquals('4acder45g', $jsonResponseModel->getTrackId());
        $this->assertEquals(2.04, $jsonResponseModel->getScriptTimeSec());

        $this->assertEquals('Alan', $jsonResponseModel->getAccountHolder()->getFirstName());
        $this->assertEquals('Turing', $jsonResponseModel->getAccountHolder()->getLastName());
        $this->assertEquals(1111111111, $jsonResponseModel->getCardToken()->getTokenId());
        $this->assertEquals('1234*******34345', $jsonResponseModel->getCardToken()->getMaskedAccountNumber());
    }

    /**
     * @return string
     */
    private function getXmlString(): string
    {
        return '<?xml version="1.0"?>
                <purchaseResponse>
                  <code>200</code>
                  <status>OK</status>
                  <message>Token Id generated</message>
                  <trackId>4acder45g</trackId>
                  <scriptTimeSec>2.04</scriptTimeSec>
                  <accountHolder>
                    <firstName>Alan</firstName>
                    <lastName>Turing</lastName>
                  </accountHolder>
                  <cardToken>
                    <tokenId>1111111111</tokenId>
                    <maskedAccountNumber>1234*******34345</maskedAccountNumber>
                  </cardToken>
                </purchaseResponse>';
    }

    /**
     * @return string
     */
    private function getJsonString(): string
    {
        return '{
                "code": 200,
                "status": "OK",
                "message": "Token Id generated",
                "trackId": "4acder45g",
                "scriptTimeSec": 2.04,
                "accountHolder": {
                    "firstName": "Alan",
                    "lastName": "Turing"
                },
                "cardToken": {
                    "tokenId": 1111111111,
                    "maskedAccountNumber": "1234*******34345"
                }
            }';
    }
}
