<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2020 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseDebit\Processor\Version1;

use JMS\Serializer\SerializerBuilder;
use Lifestyle\PaymentServiceSdk\Configuration\ConfigModel;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Processor\Version1\Processor;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\Factory;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\RequestBuilder;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataInterface;
use PHPUnit\Framework\TestCase;
use Psr\Log\LoggerInterface;
use Symfony\Component\Validator\Validation;

/**
 * Class ProcessorTest
 * @package Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseDebit\Processor\Version1
 */
class ProcessorTest extends TestCase
{
    public function test_process_purchase_debit_connection_time_out()
    {
        $factory = new Factory();
        $validator = Validation::createValidator();
        $requestBuilder = new RequestBuilder($factory, $validator);

        $configModel = new ConfigModel('urlnotfound', 'token');
        $serializer = SerializerBuilder::create()->build();

        $logger = $this->getMockBuilder(LoggerInterface::class)->getMock();
        $logger->method('error')->willReturn(true);

        $processor = new Processor($requestBuilder, $configModel, $serializer, $logger);
        $responseData = $processor->process(new RequestData());

        $this->assertInstanceOf(ResponseDataInterface::class, $responseData);
        $this->assertSame(400, $responseData->getCode());
    }
}
