<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseDebit\Request\Version1;

use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\AccountHolder;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\Factory;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\Request;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\CustomField;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\Mandate;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\Periodic;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 * @package Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseDebit\Request\Version1
 */
class FactoryTest extends TestCase
{
    public function test_factory()
    {
        $factory = new Factory();

        $this->assertInstanceOf(Request::class, $factory->request());
        $this->assertInstanceOf(AccountHolder::class, $factory->accountHolder());
        $this->assertInstanceOf(CustomField::class, $factory->customField());
        $this->assertInstanceOf(Mandate::class, $factory->mandate());
        $this->assertInstanceOf(Periodic::class, $factory->periodic());
    }
}
