<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseDebit\Request\Version1;

use Doctrine\Common\Collections\ArrayCollection;
use Lifestyle\PaymentServiceSdk\Exceptions\InvalidRequestParametersException;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\AccountHolder;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\BankAccount;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\Factory;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\Periodic;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\Mandate;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\RequestBuilder;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Validator\Validation;

/**
 * Class RequestBuilderTest
 * @package Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseDebit\Request\Version1
 */
class RequestBuilderTest extends TestCase
{
    /**
     * @throws InvalidRequestParametersException
     */
    public function test_request_builder()
    {
        $factory = new Factory();
        $validator = Validation::createValidator();

        $requestBuilder = new RequestBuilder($factory, $validator);

        $requestData = new RequestData();

        $request = $requestBuilder->buildApiRequest($requestData);
        $this->assertInstanceOf(AccountHolder::class, $request->getAccountHolder());
        $this->assertSame('Alan', $request->getAccountHolder()->getFirstName());
        $this->assertSame('Turing', $request->getAccountHolder()->getLastName());

        $this->assertSame('processNo', $request->getProcessNumber());
        $this->assertSame('1234456', $request->getParentTransactionId());
        $this->assertSame(1.99, $request->getAmount());
        $this->assertSame('EUR', $request->getCurrency());
        $this->assertSame('creditorId', $request->getCreditorId());
        $this->assertSame('paymentMethod', $request->getPaymentMethod());
        $this->assertSame('descriptor', $request->getDescriptor());

        $this->assertInstanceOf(BankAccount::class, $request->getBankAccount());
        $this->assertSame('iban', $request->getBankAccount()->getIban());
        $this->assertSame('bic', $request->getBankAccount()->getBic());

        $this->assertInstanceOf(Periodic::class, $request->getPeriodic());
        $this->assertSame('periodicType', $request->getPeriodic()->getPeriodicType());
        $this->assertSame('sequenceType', $request->getPeriodic()->getSequenceType());

        $this->assertInstanceOf(Mandate::class, $request->getMandate());
        $this->assertSame('mandateId', $request->getMandate()->getMandateId());

        $this->assertInstanceOf(ArrayCollection::class, $request->getCustomFields());
        $this->assertSame('testName', $request->getCustomFields()->first()->getName());
        $this->assertSame('testValue', $request->getCustomFields()->first()->getValue());
    }
}
