<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request\Version1;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class AccountHolder
 * @package App\Services\Wirecard\PurchaseCreditCard\Request\Version1
 */
class AccountHolder
{
    /**
     * @Assert\Length(
     *      max = 49,
     *      maxMessage = "firstName cannot be longer than {{ limit }} characters"
     * )
     * @Serializer\Type("string")
     * @Serializer\SerializedName("firstName")
     * @var string|null
     */
    private $firstName;

    /**
     * @Assert\Length(
     *      max = 49,
     *      maxMessage = "lastName cannot be longer than {{ limit }} characters"
     * )
     * @Serializer\Type("string")
     * @Serializer\SerializedName("lastName")
     * @var string|null
     */
    private $lastName;

    /**
     * @return string|null
     */
    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    /**
     * @param string|null $firstName
     */
    public function setFirstName(?string $firstName): void
    {
        $this->firstName = $firstName;
    }

    /**
     * @return string|null
     */
    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    /**
     * @param string|null $lastName
     */
    public function setLastName(?string $lastName): void
    {
        $this->lastName = $lastName;
    }
}
