<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request\Version1;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class CustomField
 * @package App\Services\Wirecard\Purchase\Request\Version1
 */
class CustomField
{
    /**
     * @Assert\Length(
     *      max = 49,
     *      maxMessage = "name cannot be longer than {{ limit }} characters"
     * )
     * @Serializer\Type("string")
     * @Serializer\SerializedName("name")
     * @var string|null
     */
    private $name;

    /**
     * @Assert\Length(
     *      max = 49,
     *      maxMessage = "value cannot be longer than {{ limit }} characters"
     * )
     * @Serializer\Type("string")
     * @Serializer\SerializedName("value")
     * @var string|null
     */
    private $value;

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     */
    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param string|null $value
     */
    public function setValue(?string $value): void
    {
        $this->value = $value;
    }
}
