<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1;

use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 * @package App\Services\LightWeight\Request\Version1
 * @Serializer\XmlRoot("wirecardPaymentDebitRequest")
 */
class Request
{
    /**
     * @Assert\Valid()
     * @Serializer\SerializedName("accountHolder")
     * @Serializer\Type("Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\AccountHolder")
     * @var AccountHolder|null
     */
    private $accountHolder;

    /**
     * @Serializer\SerializedName("processNumber")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $processNumber;

    /**
     * @Serializer\SerializedName("parentTransactionId")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $parentTransactionId;

    /**
     * @Assert\NotBlank(message="amount should not be blank!")
     * @Serializer\SerializedName("amount")
     * @Serializer\Type("float")
     * @var float|null
     */
    private $amount;

    /**
     * @Assert\NotBlank(message="currency should not be blank!")
     * @Serializer\SerializedName("currency")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $currency;

    /**
     * @Assert\NotBlank(message="client should not be blank!")
     * @Serializer\SerializedName("client")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $client;

    /**
     * @Assert\Valid()
     * @Serializer\SerializedName("customFields")
     * @Serializer\Type("ArrayCollection<Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\CustomField>")
     * @var CustomField[]|ArrayCollection|null
     */
    private $customFields;

    /**
     * @Assert\Valid()
     * @Serializer\SerializedName("mandate")
     * @Serializer\Type("Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\Mandate")
     * @var Mandate|null
     */
    private $mandate;

    /**
     * @Assert\Valid()
     * @Serializer\SerializedName("bankAccount")
     * @Serializer\Type("Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\BankAccount")
     * @var BankAccount|null
     */
    private $bankAccount;

    /**
     * @Assert\Valid()
     * @Serializer\SerializedName("periodic")
     * @Serializer\Type("Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\Periodic")
     * @var Periodic|null
     */
    private $periodic;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("creditorId")
     * @var string|null
     */
    private $creditorId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("paymentMethod")
     * @var string|null
     */
    private $paymentMethod;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("descriptor")
     * @var string|null
     */
    private $descriptor;

    /**
     * @return AccountHolder|null
     */
    public function getAccountHolder(): ?AccountHolder
    {
        return $this->accountHolder;
    }

    /**
     * @param AccountHolder|null $accountHolder
     */
    public function setAccountHolder(?AccountHolder $accountHolder): void
    {
        $this->accountHolder = $accountHolder;
    }

    /**
     * @return string|null
     */
    public function getProcessNumber(): ?string
    {
        return $this->processNumber;
    }

    /**
     * @param string|null $processNumber
     */
    public function setProcessNumber(?string $processNumber): void
    {
        $this->processNumber = $processNumber;
    }

    /**
     * @return string|null
     */
    public function getParentTransactionId(): ?string
    {
        return $this->parentTransactionId;
    }

    /**
     * @param string|null $parentTransactionId
     */
    public function setParentTransactionId(?string $parentTransactionId): void
    {
        $this->parentTransactionId = $parentTransactionId;
    }

    /**
     * @return float|null
     */
    public function getAmount(): ?float
    {
        return $this->amount;
    }

    /**
     * @param float|null $amount
     * @return Request
     */
    public function setAmount(?float $amount): Request
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCurrency(): ?string
    {
        return $this->currency;
    }

    /**
     * @param string|null $currency
     * @return Request
     */
    public function setCurrency(?string $currency): Request
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getClient(): ?string
    {
        return $this->client;
    }

    /**
     * @param string|null $client
     */
    public function setClient(?string $client): void
    {
        $this->client = $client;
    }

    /**
     * @return CustomField[]|ArrayCollection|null
     */
    public function getCustomFields()
    {
        return $this->customFields;
    }

    /**
     * @param CustomField|null $customField
     */
    public function addCustomField(?CustomField $customField): void
    {
        if (null !== $customField) {
            if (null === $this->customFields) {
                $this->customFields = new ArrayCollection();
            }
            if (!$this->customFields->contains($customField)) {
                $this->customFields->add($customField);
            }
        }
    }

    /**
     * @return Mandate|null
     */
    public function getMandate(): ?Mandate
    {
        return $this->mandate;
    }

    /**
     * @param Mandate|null $mandate
     */
    public function setMandate(?Mandate $mandate): void
    {
        $this->mandate = $mandate;
    }

    /**
     * @return BankAccount|null
     */
    public function getBankAccount(): ?BankAccount
    {
        return $this->bankAccount;
    }

    /**
     * @param BankAccount|null $bankAccount
     */
    public function setBankAccount(?BankAccount $bankAccount): void
    {
        $this->bankAccount = $bankAccount;
    }

    /**
     * @return Periodic|null
     */
    public function getPeriodic(): ?Periodic
    {
        return $this->periodic;
    }

    /**
     * @param Periodic|null $periodic
     */
    public function setPeriodic(?Periodic $periodic): void
    {
        $this->periodic = $periodic;
    }

    /**
     * @return string|null
     */
    public function getCreditorId(): ?string
    {
        return $this->creditorId;
    }

    /**
     * @param string|null $creditorId
     */
    public function setCreditorId(?string $creditorId): void
    {
        $this->creditorId = $creditorId;
    }

    /**
     * @return string|null
     */
    public function getPaymentMethod(): ?string
    {
        return $this->paymentMethod;
    }

    /**
     * @param string|null $paymentMethod
     */
    public function setPaymentMethod(?string $paymentMethod): void
    {
        $this->paymentMethod = $paymentMethod;
    }

    /**
     * @return string|null
     */
    public function getDescriptor(): ?string
    {
        return $this->descriptor;
    }

    /**
     * @param string|null $descriptor
     */
    public function setDescriptor(?string $descriptor): void
    {
        $this->descriptor = $descriptor;
    }
}
