<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class CustomField
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1
 */
class CustomField
{
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("name")
     * @var string|null
     */
    private $name;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("value")
     * @var string|null
     */
    private $value;

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }
}
