<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1;

use JMS\Serializer\Annotation as Serializer;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataMandateInterface;

/**
 * Class Mandate
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1
 */
class Mandate implements ResponseDataMandateInterface
{
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("mandateId")
     * @var string|null
     */
    private $mandateId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("signedDate")
     * @var string|null
     */
    private $signedDate;

    /**
     * @return string|null
     */
    public function getMandateId(): ?string
    {
        return $this->mandateId;
    }

    /**
     * @return string|null
     */
    public function getSignedDate(): ?string
    {
        return $this->signedDate;
    }
}
