<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2020 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataAccountHolderInterface;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataBankAccountInterface;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataCustomFieldInterface;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataInterface;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataMandateInterface;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataPeriodicInterface;
use Symfony\Component\HttpFoundation\Response as SymfonyResponse;

/**
 * Class Response
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1
 * @Serializer\XmlRoot("purchaseDebitResponse")
 */
class Response implements ResponseDataInterface
{
    /**
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("code")
     * @var integer
     */
    private $code;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("status")
     * @var string
     */
    private $status;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("message")
     * @var string|null
     */
    private $message;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("trackId")
     * @var string|null
     */
    private $trackId;

    /**
     * @Serializer\Type("double")
     * @Serializer\SerializedName("scriptTimeSec")
     * @var float|null
     */
    private $scriptTimeSec;

    /**
     * @Serializer\SerializedName("processNumber")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $processNumber;

    /**
     * @Serializer\Type("Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1\AccountHolder")
     * @Serializer\SerializedName("accountHolder")
     * @var ResponseDataAccountHolderInterface|null
     */
    private $accountHolder;

    /**
     * @Serializer\Type("Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1\BankAccount")
     * @Serializer\SerializedName("bankAccount")
     * @var ResponseDataBankAccountInterface|null
     */
    private $bankAccount;

    /**
     * @Serializer\Type("Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1\Mandate")
     * @Serializer\SerializedName("mandate")
     * @var ResponseDataMandateInterface|null
     */
    private $mandate;

    /**
     * @Serializer\Type("Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1\Periodic")
     * @Serializer\SerializedName("periodic")
     * @var ResponseDataPeriodicInterface|null
     */
    private $periodic;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("transactionId")
     * @var string|null
     */
    private $transactionId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("requestId")
     * @var string|null
     */
    private $requestId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("merchantAccountId")
     * @var string|null
     */
    private $merchantAccountId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("parentTransactionId")
     * @var string|null
     */
    private $parentTransactionId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("transactionType")
     * @var string|null
     */
    private $transactionType;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("paymentMethodsName")
     * @var string|null
     */
    private $paymentMethodsName;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("creditorId")
     * @var string|null
     */
    private $creditorId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("dueDate")
     * @var string|null
     */
    private $dueDate;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("apiId")
     * @var string|null
     */
    private $apiId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("locale")
     * @var string|null
     */
    private $locale;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("providerTransactionReferenceId")
     * @var string|null
     */
    private $providerTransactionReferenceId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("currency")
     * @var string|null
     */
    private $currency;

    /**
     * @Serializer\Type("float")
     * @Serializer\SerializedName("amount")
     * @var float|null
     */
    private $amount;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("descriptor")
     * @var string|null
     */
    private $descriptor;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("authorizationCode")
     * @var string|null
     */
    private $authorizationCode;

    /**
     * @Serializer\SerializedName("customFields")
     * @Serializer\Type("ArrayCollection<Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1\CustomField>")
     * @var ResponseDataCustomFieldInterface[]|ArrayCollection|null
     */
    private $customFields;

    /**
     * @return int
     */
    public function getCode(): int
    {
        return $this->code;
    }

    /**
     * @param int|null $code
     */
    public function setCode(?int $code): void
    {
        $this->code = $code;

        if (null !== $code) {
            $this->setStatus($this->getStatusText($code));
        }
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }

    /**
     * @param string $status
     */
    public function setStatus(string $status): void
    {
        $this->status = $status;
    }

    /**
     * @return string|null
     */
    public function getMessage(): ?string
    {
        return $this->message;
    }

    /**
     * @param string|null $message
     */
    public function setMessage(?string $message): void
    {
        $this->message = $message;
    }

    /**
     * @return string|null
     */
    public function getTrackId(): ?string
    {
        return $this->trackId;
    }

    /**
     * @param string|null $trackId
     */
    public function setTrackId(?string $trackId): void
    {
        $this->trackId = $trackId;
    }

    /**
     * @return float|null
     */
    public function getScriptTimeSec(): ?float
    {
        return $this->scriptTimeSec;
    }

    /**
     * @param float|null $scriptTimeSec
     */
    public function setScriptTimeSec(?float $scriptTimeSec): void
    {
        $this->scriptTimeSec = $scriptTimeSec;
    }

    /**
     * @return string|null
     */
    public function getProcessNumber(): ?string
    {
        return $this->processNumber;
    }

    /**
     * @return ResponseDataAccountHolderInterface|null
     */
    public function getAccountHolder(): ?ResponseDataAccountHolderInterface
    {
        return $this->accountHolder;
    }

    /**
     * @return ResponseDataBankAccountInterface|null
     */
    public function getBankAccount(): ?ResponseDataBankAccountInterface
    {
        return $this->bankAccount;
    }

    /**
     * @return ResponseDataMandateInterface|null
     */
    public function getMandate(): ?ResponseDataMandateInterface
    {
        return $this->mandate;
    }

    /**
     * @return ResponseDataPeriodicInterface|null
     */
    public function getPeriodic(): ?ResponseDataPeriodicInterface
    {
        return $this->periodic;
    }

    /**
     * @return string|null
     */
    public function getTransactionId(): ?string
    {
        return $this->transactionId;
    }

    /**
     * @return string|null
     */
    public function getRequestId(): ?string
    {
        return $this->requestId;
    }

    /**
     * @return string|null
     */
    public function getMerchantAccountId(): ?string
    {
        return $this->merchantAccountId;
    }

    /**
     * @return string|null
     */
    public function getParentTransactionId(): ?string
    {
        return $this->parentTransactionId;
    }

    /**
     * @return string|null
     */
    public function getTransactionType(): ?string
    {
        return $this->transactionType;
    }

    /**
     * @return string|null
     */
    public function getPaymentMethodsName(): ?string
    {
        return $this->paymentMethodsName;
    }

    /**
     * @return string|null
     */
    public function getCreditorId(): ?string
    {
        return $this->creditorId;
    }

    /**
     * @return string|null
     */
    public function getDueDate(): ?string
    {
        return $this->dueDate;
    }

    /**
     * @return string|null
     */
    public function getApiId(): ?string
    {
        return $this->apiId;
    }

    /**
     * @return string|null
     */
    public function getLocale(): ?string
    {
        return $this->locale;
    }

    /**
     * @return string|null
     */
    public function getProviderTransactionReferenceId(): ?string
    {
        return $this->providerTransactionReferenceId;
    }

    /**
     * @return string|null
     */
    public function getCurrency(): ?string
    {
        return $this->currency;
    }

    /**
     * @return float|null
     */
    public function getAmount(): ?float
    {
        return $this->amount;
    }

    /**
     * @return string|null
     */
    public function getDescriptor(): ?string
    {
        return $this->descriptor;
    }

    /**
     * @return string|null
     */
    public function getAuthorizationCode(): ?string
    {
        return $this->authorizationCode;
    }

    /**
     * @return ArrayCollection|ResponseDataCustomFieldInterface[]|null
     */
    public function getCustomFields()
    {
        return $this->customFields;
    }

    /**
     * @param int $statusCode
     * @return string
     */
    private function getStatusText(int $statusCode): string
    {
        return isset(SymfonyResponse::$statusTexts[$statusCode]) ? SymfonyResponse::$statusTexts[$statusCode] : 'unknown';
    }
}
