<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseDebit\Request\Version1;

use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\AccountHolder;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\BankAccount;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\CustomField;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1\Request;
use JMS\Serializer\SerializerBuilder;
use PHPUnit\Framework\TestCase;

/**
 * Class RequestTest
 * @package Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseDebit\Request\Version1
 */
class RequestTest extends TestCase
{

    public function test_request_model()
    {
        $serializer = SerializerBuilder::create()->build();
        $requestModel = $this->getRequestModel();

        $xml = $serializer->serialize($requestModel, 'xml');
        $this->assertXmlStringEqualsXmlString($this->getXmlString(), $xml);

        $json = $serializer->serialize($requestModel, 'json');
        $this->assertJsonStringEqualsJsonString($this->getJsonString(), $json);

        //also test the getter
        $this->assertEquals('Alan', $requestModel->getAccountHolder()->getFirstName());
        $this->assertEquals('Turing', $requestModel->getAccountHolder()->getLastName());
        $this->assertEquals('EUR', $requestModel->getCurrency());
        $this->assertEquals('1.23', $requestModel->getAmount());
        $this->assertEquals('4711', $requestModel->getProcessNumber());
    }

    /**
     * @return Request
     */
    private function getRequestModel(): Request
    {
        $requestModel = new Request();

        $accountHolder = new AccountHolder();
        $accountHolder->setFirstName('Alan');
        $accountHolder->setLastName('Turing');
        $requestModel->setAccountHolder($accountHolder);

        $requestModel->setCurrency('EUR');
        $requestModel->setAmount(1.23);
        $requestModel->setProcessNumber('4711');

        $requestModel->setCreditorId('DE06ZZZ00000025469');
        $requestModel->setDescriptor('Buchungsnr. 13494778');

        //bank account
        $bankAccountModel = new BankAccount();
        $bankAccountModel->setIban('DE42512308000000060004');
        $bankAccountModel->setBic('WIREDEMMXXX');
        $requestModel->setBankAccount($bankAccountModel);


        $customFieldModel = new CustomField();
        $customFieldModel->setName('flight');
        $customFieldModel->setValue('23233434344');

        $requestModel->addCustomField($customFieldModel);

        return $requestModel;
    }

    /**
     * @return string
     */
    private function getXmlString(): string
    {
        return '<?xml version="1.0"?>
                <wirecardPaymentDebitRequest>
                  <accountHolder>
                  <firstName>Alan</firstName>
                  <lastName>Turing</lastName>
                  </accountHolder>
                  <processNumber>4711</processNumber>
                  <amount>1.23</amount>
                  <currency>EUR</currency>
                  <customFields>
                    <entry>
                      <name>flight</name>
                      <value>23233434344</value>
                    </entry>
                  </customFields>
                  <bankAccount>
                    <iban>DE42512308000000060004</iban>
                    <bic>WIREDEMMXXX</bic>
                  </bankAccount>
                  <creditorId>DE06ZZZ00000025469</creditorId>
                  <descriptor>Buchungsnr. 13494778</descriptor>
                </wirecardPaymentDebitRequest>';
    }

    /**
     * @return string
     */
    private function getJsonString(): string
    {
        return '{
                "accountHolder": {
                    "firstName": "Alan",
                    "lastName": "Turing"
                },
                "processNumber": "4711",
                "amount": 1.23,
                "currency": "EUR",
                "customFields": [
                    {
                        "name": "flight",
                        "value": "23233434344"
                    }
                ],
                "bankAccount": {
                    "iban": "DE42512308000000060004",
                    "bic": "WIREDEMMXXX"
                },
                "creditorId": "DE06ZZZ00000025469",
                "descriptor": "Buchungsnr. 13494778"
            }';
    }
}
