<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Processor;

use Lifestyle\PaymentServiceSdk\Exceptions\InvalidRequestVersionException;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\ProcessorInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Exception\InvalidArgumentException;

/**
 * Class ProcessorFactory
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Processor
 */
class ProcessorFactory
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * ProcessorFactory constructor.
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }

    /**
     * @param int $apiVersion
     * @return ProcessorInterface
     * @throws InvalidRequestVersionException
     */
    public function createProcessor(int $apiVersion): ProcessorInterface
    {
        try {
            $service = $this->container->get(__NAMESPACE__ . '\\Version' . $apiVersion . '\\Processor');

            if (!$service instanceof ProcessorInterface) {
                throw new InvalidArgumentException('Could not find a matching ' . ProcessorInterface::class . ' implementation.');
            }

            return $service;
        } catch (InvalidArgumentException $exception) {
            throw new InvalidRequestVersionException($apiVersion, $exception);
        }
    }
}
