<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2020 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request\Version1;

use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 * @package App\Services\Wirecard\PurchaseCreditCard\Request\Version1
 * @Serializer\XmlRoot("wirecardPaymentCreditCardRequest")
 */
class Request
{
    /**
     * @Assert\Valid()
     * @Serializer\SerializedName("accountHolder")
     * @Serializer\Type("Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request\Version1\AccountHolder")
     * @var AccountHolder|null
     */
    private $accountHolder;

    /**
     * @Serializer\SerializedName("processNumber")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $processNumber;

    /**
     * @Assert\NotBlank(message="tokenId should not be blank!")
     * @Assert\Type(type="integer", message="tokenId should be of type integer.")
     * @Serializer\SerializedName("tokenId")
     * @Serializer\Type("integer")
     * @var integer|null
     */
    private $tokenId;

    /**
     * @Assert\NotBlank(message="amount should not be blank!")
     * @Serializer\SerializedName("amount")
     * @Serializer\Type("float")
     * @var float|null
     */
    private $amount;

    /**
     * @Assert\NotBlank(message="currency should not be blank!")
     * @Serializer\SerializedName("currency")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $currency;

    /**
     * @Assert\NotBlank(message="client should not be blank!")
     * @Serializer\SerializedName("client")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $client;

    /**
     * @Assert\Valid()
     * @Serializer\SerializedName("customFields")
     * @Serializer\Type("ArrayCollection<Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request\Version1\CustomField>")
     * @var CustomField[]|ArrayCollection|null
     */
    private $customFields;

    /**
     * @return AccountHolder|null
     */
    public function getAccountHolder(): ?AccountHolder
    {
        return $this->accountHolder;
    }

    /**
     * @param AccountHolder|null $accountHolder
     */
    public function setAccountHolder(?AccountHolder $accountHolder): void
    {
        $this->accountHolder = $accountHolder;
    }

    /**
     * @return string|null
     */
    public function getProcessNumber(): ?string
    {
        return $this->processNumber;
    }

    /**
     * @param string|null $processNumber
     */
    public function setProcessNumber(?string $processNumber): void
    {
        $this->processNumber = $processNumber;
    }

    /**
     * @return int|null
     */
    public function getTokenId(): ?int
    {
        return $this->tokenId;
    }

    /**
     * @param int|null $tokenId
     */
    public function setTokenId(?int $tokenId): void
    {
        $this->tokenId = $tokenId;
    }

    /**
     * @return float|null
     */
    public function getAmount(): ?float
    {
        return $this->amount;
    }

    /**
     * @param float|null $amount
     * @return Request
     */
    public function setAmount(?float $amount): Request
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCurrency(): ?string
    {
        return $this->currency;
    }

    /**
     * @param string|null $currency
     * @return Request
     */
    public function setCurrency(?string $currency): Request
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getClient(): ?string
    {
        return $this->client;
    }

    /**
     * @param string|null $client
     */
    public function setClient(?string $client): void
    {
        $this->client = $client;
    }

    /**
     * @return CustomField[]|ArrayCollection|null
     */
    public function getCustomFields()
    {
        return $this->customFields;
    }

    /**
     * @param CustomField|null $customField
     */
    public function addCustomField(?CustomField $customField): void
    {
        if (null !== $customField) {
            if (null === $this->customFields) {
                $this->customFields = new ArrayCollection();
            }
            if (!$this->customFields->contains($customField)) {
                $this->customFields->add($customField);
            }
        }
    }
}
