<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Interface ResponseDataInterface
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response
 */
interface ResponseDataInterface
{
    /**
     * @return int|null
     */
    public function getCode(): ?int;

    /**
     * @return string|null
     */
    public function getStatus(): ?string;

    /**
     * @return string|null
     */
    public function getMessage(): ?string;

    /**
     * @return string|null
     */
    public function getTrackId(): ?string;

    /**
     * @return float|null
     */
    public function getScriptTimeSec(): ?float;

    /**
     * @return string|null
     */
    public function getProcessNumber(): ?string;

    /**
     * @return string|null
     */
    public function getTransactionId(): ?string;

    /**
     * @return string|null
     */
    public function getRequestId(): ?string;

    /**
     * @return ResponseDataAccountHolderInterface|null
     */
    public function getAccountHolder(): ?ResponseDataAccountHolderInterface;

    /**
     * @return ResponseDataCardTokenInterface|null
     */
    public function getCardToken(): ?ResponseDataCardTokenInterface;

    /**
     * @return string|null
     */
    public function getCurrency(): ?string;

    /**
     * @return float|null
     */
    public function getAmount(): ?float;

    /**
     * @return string|null
     */
    public function getDescriptor(): ?string;

    /**
     * @return string|null
     */
    public function getAuthorizationCode(): ?string;

    /**
     * @return ArrayCollection|ResponseDataCustomFieldInterface[]|null
     */
    public function getCustomFields();

    /**
     * @return ArrayCollection|ResponseDataStatusInterface[]|null
     */
    public function getStatuses();
}
