<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\Version1;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\ResponseDataAccountHolderInterface;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\ResponseDataCardTokenInterface;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\ResponseDataInterface;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\ResponseDataStatusInterface;
use Symfony\Component\HttpFoundation\Response as SymfonyResponse;

/**
 * Class Response
 * @package App\Services\LightWeight\Response\Version1
 * @Serializer\XmlRoot("purchaseResponse")
 */
class Response implements ResponseDataInterface
{
    /**
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("code")
     * @var integer|null
     */
    private $code;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("status")
     * @var string|null
     */
    private $status;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("message")
     * @var string|null
     */
    private $message;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("trackId")
     * @var string|null
     */
    private $trackId;

    /**
     * @Serializer\Type("double")
     * @Serializer\SerializedName("scriptTimeSec")
     * @var float|null
     */
    private $scriptTimeSec;

    /**
     * @Serializer\SerializedName("processNumber")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $processNumber;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("transactionId")
     * @var string|null
     */
    private $transactionId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("requestId")
     * @var string|null
     */
    private $requestId;

    /**
     * @Serializer\Type("Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\Version1\AccountHolder")
     * @Serializer\SerializedName("accountHolder")
     * @var AccountHolder|null
     */
    private $accountHolder;

    /**
     * @Serializer\Type("Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\Version1\CardToken")
     * @Serializer\SerializedName("cardToken")
     * @var CardToken|null
     */
    private $cardToken;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("currency")
     * @var string|null
     */
    private $currency;

    /**
     * @Serializer\Type("float")
     * @Serializer\SerializedName("amount")
     * @var float|null
     */
    private $amount;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("descriptor")
     * @var string|null
     */
    private $descriptor;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("authorizationCode")
     * @var string|null
     */
    private $authorizationCode;

    /**
     * @Serializer\SerializedName("customFields")
     * @Serializer\Type("ArrayCollection<Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\Version1\CustomField>")
     * @var CustomField[]|ArrayCollection|null
     */
    private $customFields;

    /**
     * @Serializer\SerializedName("statuses")
     * @Serializer\Type("ArrayCollection<Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\Version1\Status>")
     * @var CustomField[]|ArrayCollection|null
     */
    private $statuses;

    /**
     * @return int|null
     */
    public function getCode(): ?int
    {
        return $this->code;
    }

    /**
     * @param int|null $code
     */
    public function setCode(?int $code): void
    {
        $this->code = $code;

        if (null !== $code) {
            $this->setStatus($this->getStatusText($code));
        }
    }

    /**
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @param string|null $status
     */
    public function setStatus(?string $status): void
    {
        $this->status = $status;
    }

    /**
     * @return string|null
     */
    public function getMessage(): ?string
    {
        return $this->message;
    }

    /**
     * @param string|null $message
     */
    public function setMessage(?string $message): void
    {
        $this->message = $message;
    }

    /**
     * @return string|null
     */
    public function getTrackId(): ?string
    {
        return $this->trackId;
    }

    /**
     * @return float|null
     */
    public function getScriptTimeSec(): ?float
    {
        return $this->scriptTimeSec;
    }

    /**
     * @return string|null
     */
    public function getProcessNumber(): ?string
    {
        return $this->processNumber;
    }

    /**
     * @return string|null
     */
    public function getTransactionId(): ?string
    {
        return $this->transactionId;
    }

    /**
     * @return string|null
     */
    public function getRequestId(): ?string
    {
        return $this->requestId;
    }

    /**
     * @return ResponseDataAccountHolderInterface|null
     */
    public function getAccountHolder(): ?ResponseDataAccountHolderInterface
    {
        return $this->accountHolder;
    }

    /**
     * @return ResponseDataCardTokenInterface|null
     */
    public function getCardToken(): ?ResponseDataCardTokenInterface
    {
        return $this->cardToken;
    }

    /**
     * @return string|null
     */
    public function getCurrency(): ?string
    {
        return $this->currency;
    }

    /**
     * @return float|null
     */
    public function getAmount(): ?float
    {
        return $this->amount;
    }

    /**
     * @return string|null
     */
    public function getDescriptor(): ?string
    {
        return $this->descriptor;
    }

    /**
     * @return string|null
     */
    public function getAuthorizationCode(): ?string
    {
        return $this->authorizationCode;
    }

    /**
     * @return ArrayCollection|CustomField[]|null
     */
    public function getCustomFields()
    {
        return $this->customFields;
    }

    /**
     * @return ArrayCollection|CustomField[]|null
     */
    public function getStatuses()
    {
        return $this->statuses;
    }

    /**
     * @param int $statusCode
     * @return string
     */
    private function getStatusText(int $statusCode): string
    {
        return isset(SymfonyResponse::$statusTexts[$statusCode]) ? SymfonyResponse::$statusTexts[$statusCode] : 'unknown';
    }
}
