<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request;

use Doctrine\Common\Collections\ArrayCollection;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\Common\CustomFieldInterface;
use DateTime;

/**
 * Interface RequestDataInterface
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request
 */
interface RequestDataInterface
{
    /**
     * @return string|null
     */
    public function getFirstName(): ?string;

    /**
     * @return string|null
     */
    public function getLastName(): ?string;

    /**
     * @return string|null
     */
    public function getProcessNumber(): ?string;

    /**
     * @return string|null
     */
    public function getParentTransactionId(): ?string;

    /**
     * @return float|null
     */
    public function getAmount(): ?float;

    /**
     * @return string|null
     */
    public function getCurrency(): ?string;

    /**
     * @return string|null
     */
    public function getClient(): ?string;

    /**
     * @return string|null
     */
    public function getCreditorId(): ?string;

    /**
     * @return string|null
     */
    public function getPaymentMethod(): ?string;

    /**
     * @return string|null
     */
    public function getDescriptor(): ?string;

    /**
     * @return string|null
     */
    public function getMandateId(): ?string;

    /**
     * @return DateTime|null
     */
    public function getMandateSignedDate(): ?DateTime;

    /**
     * @return string|null
     */
    public function getPeriodicType(): ?string;

    /**
     * @return string|null
     */
    public function getSequenceType(): ?string;

    /**
     * @return string|null
     */
    public function getIban(): ?string;

    /**
     * @return string|null
     */
    public function getBic(): ?string;

    /**
     * @return CustomFieldInterface[]|ArrayCollection|null
     */
    public function getCustomFields(): ?ArrayCollection;
}