<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\Version1;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class BankAccount
 * @package App\Services\Wirecard\PurchaseDebit\Request\Version1
 */
class BankAccount
{
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("iban")
     * @var string|null
     */
    private $iban;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("bic")
     * @var string|null
     */
    private $bic;

    /**
     * @return string|null
     */
    public function getIban(): ?string
    {
        return $this->iban;
    }

    /**
     * @param string|null $iban
     */
    public function setIban(?string $iban): void
    {
        $this->iban = $iban;
    }

    /**
     * @return string|null
     */
    public function getBic(): ?string
    {
        return $this->bic;
    }

    /**
     * @param string|null $bic
     */
    public function setBic(?string $bic): void
    {
        $this->bic = $bic;
    }
}
