<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2020 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1;

use JMS\Serializer\Annotation as Serializer;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataAccountHolderInterface;

/**
 * Class AccountHolder
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1
 */
class AccountHolder implements ResponseDataAccountHolderInterface
{
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("firstName")
     * @var string|null
     */
    private $firstName;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("lastName")
     * @var string|null
     */
    private $lastName;

    /**
     * @return string|null
     */
    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    /**
     * @return string|null
     */
    public function getLastName(): ?string
    {
        return $this->lastName;
    }
}
