<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1;

use JMS\Serializer\Annotation as Serializer;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataPeriodicInterface;

/**
 * Class Periodic
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1
 */
class Periodic implements ResponseDataPeriodicInterface
{
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("periodicType")
     * @var string|null
     */
    private $periodicType;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("sequenceType")
     * @var string|null
     */
    private $sequenceType;

    /**
     * @return string|null
     */
    public function getPeriodicType(): ?string
    {
        return $this->periodicType;
    }

    /**
     * @return string|null
     */
    public function getSequenceType(): ?string
    {
        return $this->sequenceType;
    }
}
